#version 150
#extension GL_EXT_gpu_shader4 : enable
///////////////////////////////////////////////////////////////////////////////////////////////////
// iStripper wrapper for Shadertoy conversions by @Calgon  //
///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Notes
//
// Idea was to create a standard wrapper around Shadertoy code that could be applied to any shader
// sourced from Shadertoy.
// Version number is 150 as standard but where later functions are found this is changed to 330

// Wrapper Follows....
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Declare the missing thingamies that aren't available on VGHD
uniform vec3  iChannelResolution[4];	// BUT WE NEED TO FILL THEM !
uniform float iChannelTime[4];

//#define iResolution u_WindowSize
#define iResolution vec3(u_WindowSize, 0)	// Because Shadertoy iResolution is a vec3
#define iFrame 0


//Slow the time functions down a little as standard
//#define iTime u_Elapsed * .5
float iTime;

#define iGlobalTime u_Elapsed * .5

// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy texture0..3 with texture 0..3 further down
uniform sampler2D texture0; //Random Surfaces
uniform sampler2D texture1; //Water
uniform sampler2D texture2; //Random Greys
uniform sampler2D texture3; //More surfaces

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

#define texture texture2D_Fract	// So whenever Shadertoy says "texture" we run it through this Macro
// Can we do the same for Cubemaps 

#define iChannel0 texture0
#define iChannel1 texture1
#define iChannel2 texture2
#define iChannel3 texture3

// Mouse Simulation from @TheEmu	
#define iMouse vec4(0.)
// Alternative Macro if iMouse is better moving
//#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)
// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
//#define MOUSE_POS vec2((0.25+sin(iTime*MOUSE_SPEED*2))*u_WindowSize/2.0)
//#define MOUSE_POS vec2((sin(iTime*1)*.5*u_WindowSize.x/2.0),1.0*u_WindowSize.y/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



vec4 iDate;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Uniforms to control timing of each shader
//uniform float cycle_time;
uniform float bgnum;
uniform float maxbgnum;
//uniform float alpha_off;
//uniform float alpha_on;
//uniform float alpha_always_on;
uniform float scene_duration;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Extract a pixel from texture1 to get the random number
float randNum = texture(texture2, vec2(0.0, 0.0)).r;
float seed_start = 3*randNum-1.5;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
///////////////////////////////////////////////////////////////////////////////////////////////////

// Sourced from https://www.shadertoy.com/view/4st3DS

const float pi = 3.14159;
const float pi2 = pi * 2.;

const vec2 cellSizePixels = vec2(192.,192.);// best results = any multiple of 2^iterations
float edgeSizePixels = 2.5;
const float iterations = 5.;


vec2 q(vec2 x, vec2 p)
{
    return floor(x/p)*p;
}

float rand(vec2 co){
  return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec3 rand3(vec2 p)
{
    vec3 p2 = vec3(p, rand(p));
    return
        fract(sin(vec3(
            dot(p2,vec3(127.1,311.7,427.89)),
            dot(p2,vec3(269.5,183.3,77.24)),
            dot(p2,vec3(42004.33,123.54,714.24))
            ))*43758.5453);
}

float sdAxisAlignedRect(vec2 uv, vec2 tl, vec2 br)
{
  	vec2 d = max(tl - uv, uv - br);
    return length(max(vec2(0.0), d)) + min(0.0, max(d.x, d.y));
}

mat2 rot2D(float r)
{
    float c = cos(r), s = sin(r);
    return mat2(c, s, -s, c);
}
float pulse(float x, float pulseWidth, float totalPeriod)
{
    x = mod(x,totalPeriod);
    x -= pulseWidth /= 2.;
    return 1.-smoothstep(0.,pulseWidth, abs(x));
}



void mainImage( out vec4 o, in vec2 i)
{
	vec2 uv = i / iResolution.xy - .5;
    vec2 uvn = uv;// screen / unwarped coords

    uv += iMouse.xy *.1 / iResolution.xy;
    
	if(iResolution.x > iResolution.y)
		uv.x *= iResolution.x / iResolution.y;
	else
		uv.y /= iResolution.x / iResolution.y;

    
    //uv *= 1.+sin(iTime*0.5)*.1;// zoom
    uv -= .7;// offset rotation origin
    float rotation = -(iTime+40.)*0.005;
    //rotation = -0.2;// fixed-rot
    uv *= rot2D(rotation);// rot
    
    vec2 cellSize = cellSizePixels / iResolution.x;

    vec2 cellOrig;
    float cellID;
    float edgeSizePixels = 7.;

    for(float i = 0.;i<iterations;i++)
    {
        cellSize *= .5;
        edgeSizePixels *= .5;
        cellOrig = q(uv, cellSize);
        cellID = rand(cellOrig);
        if(i/iterations > sin(cellID*6.28+iTime*.2)*.5+.3)
            break;
    }
    edgeSizePixels = max(edgeSizePixels, 1.);
    
    //float cellID = rand(cellOrig);
    float distToCenter = distance(uv, cellOrig+cellSize/2.)/(length(cellSize)/2.);
    vec2 tl = cellOrig;
    vec2 br = cellOrig + cellSize;
    float distToEdge = sdAxisAlignedRect(uv, tl, br) / length(cellSize);// 0 = edge, -1 = center
    
    float edgeSize = edgeSizePixels/iResolution.x/length(cellSize);
    float aEdge = smoothstep(-edgeSize, 0., distToEdge);
    
    float totalPulsePeriod = 10.;// in seconds
    float highlightDuration = 1.2;
    float highlightStrength = 1.7;
    float highlight = pulse((cellID*totalPulsePeriod*totalPulsePeriod)+iTime,highlightDuration,totalPulsePeriod)*highlightStrength+1.;
    
    // cell background
    vec3 cellColor = rand3(cellOrig);
    o = vec4(cellColor.rgbb)*.3;
    o *= highlight;
    o *= 1.-distToCenter*.4;
    
    // edge color
    vec4 edgeColor = vec4(0,0,0,1);
    o = mix(o, edgeColor, aEdge);

    // saturation
    o = clamp(o,0.,1.);
    //o = mix(o, vec4((o.r+o.g+o.b)/3.), sin(iTime)*.5+.5);
    o = mix(o, vec4((o.r+o.g+o.b)/3.), .6);

    // tint green / brightness
    o *= vec4(.5,1,1,0)*2.;
    
    // noise
    o.rgb += (rand3(uvn*iTime)-.5)*.1;

    // vignette
    uvn *= 1.1;
    o *= 1.-dot(uvn,uvn);
    
    // gamma
    o = clamp(o,0.,1.);
    o = pow(o, vec4(1./1.2));
}



///////////////////////////////////////////////////////////////////////
// Shadertoy footer wrapper
///////////////////////////////////////////////////////////////////////

void main ( void )
{
	float alpha_on;
	float alpha_off;


	if (bgnum > 0){
		alpha_on  = scene_duration * (bgnum - 1.);
		alpha_off = scene_duration * (bgnum + 0.);
	}
	if (bgnum == 0){
		alpha_on  = scene_duration * (maxbgnum) - 1;
		alpha_off = scene_duration * (maxbgnum) + 1;
	}

	
	
	

	iTime = u_Elapsed * .5;


	if (iTime > 6000.){
		iTime = 6000. * fract(iTime / 6000.);
	}
	float cycle_time = maxbgnum * scene_duration;
	float cycles = (u_Elapsed)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	vec4 blank = vec4(0.);
	
	// Run the full program only at the right time..
	if ((part_cycles > alpha_on-1.)&&(part_cycles <= alpha_off+1.)){
		mainImage ( gl_FragColor, gl_FragCoord.xy );
		gl_FragColor.a = 1.0;
	}
	// Otherwise... just blank => massive performance boost
	else{
		gl_FragColor = blank;		
    }
	// Still need to fade it
	gl_FragColor.a = 0.0;
   if (part_cycles > alpha_on-1.){
	if (part_cycles <= alpha_off){
		gl_FragColor.a = 1.;
		if ((alpha_off - part_cycles)<1.){
			gl_FragColor.a = alpha_off - part_cycles;
		}
	}
   }
}


